<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Adapter_transacao {
    /*
      id	int(11)	Não
      id_user	int(11)	Não // sessao
      id_revenda	int(11)	Não // sessao
      tipo	int(11)	Não /1-pagseguro,2-Boleto Facil 3-deposito
      valor_un	decimal(10,0)	Não
      qtd_meses	int(11)	Não
      valor_total	decimal(10,0)	Não
      data_cad	datetime	Não
      data_atualizacao	datetime	Não
      status	int(11)	Não 1-aberto, 2-aguardando pagamento, 3-aprovado , 4-fechado
     */

    private $transacao;
    private $CI;

    public function __construct($dados_transacao = null) {
        $this->transacao = $dados_transacao;
        $this->CI = & get_instance();
    }

    public function setTransacao($dados_transacao = null) {
        $this->transacao = $dados_transacao;
    }

    function getTipoString($int_tipo = null) {

        $tipo[1] = 'Pagseguro';
        $tipo[2] = 'Boleto Facil';
        $tipo[3] = 'Deposito/TEV';

        if (is_numeric($int_tipo) && key_exists($int_tipo, $tipo) === true) {
            return $tipo[$int_tipo];
        }

        if (isset($this->transacao['tipo']) && array_key_exists($this->transacao['tipo'], $tipo)) {
            return $tipo[$this->transacao['tipo']];
        }
    }

    function getStatusString($int_status = null) {

        $status[0] = 'Cancelada';
        $status[1] = 'Aberta';
        $status[2] = 'Aguardando Pagamento';
        $status[3] = 'Aprovada';
        $status[4] = 'Problemas com cliente';
        $status[5] = 'Fechada';

        if (is_numeric($int_status) && key_exists($int_status, $status)) {
            return $status[$int_status];
        }

        if (isset($this->transacao['status'])) {
            return $status[$this->transacao['status']];
        }
    }

    function getDataCad_BR($data_us = null) {

        if (null !== $data_us) {
            return $this->getData_BR($data_us);
        }

        if (isset($this->transacao['data_cad'])) {
            return $this->getData_BR($this->transacao['data_cad']);
        }
    }

    function getDataAtualizacao_BR($data_us = null) {

        if (null !== $data_us) {
            return $this->getData_BR($data_us);
        }

        if (isset($this->transacao['data_atualizacao'])) {
            return $this->getData_BR($this->transacao['data_atualizacao']);
        }
    }

    private function getData_BR($data_us = null) {
        $this->CI->load->helper('MY_convertdata');
        return dataBr($data_us);
    }

}
