<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Planos extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function salvar() {
        //data: {desc_plano: desc_plano, qtd_login: qtd_login, valor_cobrado: valor_cobrado}


        $id_plano = (int) $this->_antiSqlInject($_POST['id_plano']);
        $revenda_id = $this->_antiSqlInject($this->sessao_nativa->get('adminid'));
        $desc_plano = $this->_antiSqlInject($_POST['desc_plano']);
        $qtd_login = $this->_antiSqlInject($_POST['qtd_login']);
        $valor_cobrado = $this->_antiSqlInject($_POST['valor_cobrado']);
        $status = 1;

        $retorno = array();


        if ($id_plano === 0) {

            // limitando o total de planos cadastrado

            $rs = $this->db->query('SELECT * FROM cmum_planos_pre');

            if ($rs->num_rows() > 4) {
                $retorno['erro'] = "Você não pode ter mais do que 4 planos ativos.";
                exit(json_encode($retorno));
            }


            if ($this->db->insert('cmum_planos_pre', array('id_revenda' => $revenda_id, 'desc_plano' => $desc_plano, 'qtd_login' => $qtd_login, 'valor_cobrado' => $valor_cobrado, 'data_cad' => date('Y-m-d'), 'status' => $status))) {
                $retorno['sucesso'] = 'Dados Salvos Com Sucesso!';
            }
        } else {
            if ($this->db->update('cmum_planos_pre', array('id_revenda' => $revenda_id, 'desc_plano' => $desc_plano, 'qtd_login' => $qtd_login, 'valor_cobrado' => $valor_cobrado, 'status' => $status), array('id' => $id_plano))) {
                $retorno['sucesso'] = 'Dados Atualizados Com Sucesso!';
            }
        }

        exit(json_encode($retorno));
    }

    function planos_compra() {

        $revenda_pai = $this->_antiSqlInject($this->sessao_nativa->get('admin_pai'));


        $rs = $this->db->query("SELECT * FROM cmum_planos_pre WHERE id_revenda={$revenda_pai} AND status = 1 ORDER BY valor_cobrado ASC LIMIT 0,4 ");

        $planos = array();

        if ($rs->num_rows() > 0) {
            $planos = $rs->result_array();
        }

        $this->load->view('Planos/planos.compra.php', compact('planos'));
    }

    function cria_pagamento($id_plano = null) {

        if (null === $id_plano || !is_numeric($id_plano)) {
            exit();
        }

        //??? Pega o id do user por sessao ???

        $rs = $this->db->query("SELECT * FROM cmum_planos_pre WHERE id={$id_plano}");

        if ($rs->num_rows() > 0) {
            $plano = $rs->row_array();
        }


        $this->load->view('Comum/Comum.topo.php', array('subtitulo' => 'Efetuar Pagamento'));
        $this->load->view('Planos/planos.cria_pagamento.php', array('plano' => $plano));
    }

    function efetua_pagamento($id_plano = null) {


        $id_revenda = intval($this->_antiSqlInject($this->sessao_nativa->get('adminid')));
        $id_pai = intval($this->_antiSqlInject($this->sessao_nativa->get('admin_pai')));
        $id_plano = intval($this->_antiSqlInject($_POST['id_plano']));

        // verifica se o plano pertence a revenda

        $rs = $this->db->query("SELECT * FROM cmum_planos_pre WHERE id = {$id_plano} AND id_revenda = {$id_pai}");

        if ($rs->num_rows() == 0) {

            $javascript = <<< EOF
                 <script>
                    alert('Error interno.');
                    window.history.go(-1);
                 </script>                
EOF;
            exit($javascript);
        }

        $dados_plano = $rs->row_array();

        //funções da raiz do sistema
        require_once INC_GLOBAL . DIRECTORY_SEPARATOR . 'functions.php';

        $_saldo_revenda_pre = saldo_revenda_pre($id_pai);
        $saldo_revenda_pre = $_saldo_revenda_pre[$id_pai];

        //var_dump($saldo_revenda_pre);exit();

        if ($saldo_revenda_pre['saldo_real'] < ((int) $dados_plano['qtd_login']) || $saldo_revenda_pre['saldo_real'] <= 0) {

            $javascript = <<<js
        <script>
            alert('A Revenda não tem saldo suficiente pra liberação. Veja um plano com uma quantidade menor em logins ou entre em contato com seu revendedor!');
            window.history.go(-1);
        </script>       
js;
            exit($javascript);
        }

        $dados_salvar['id_revenda'] = $id_revenda;
        $dados_salvar['id_pai'] = $id_pai;
        $dados_salvar['id_plano'] = $dados_plano['id'];
        $dados_salvar['tipo'] = $this->_antiSqlInject($_POST['forma_pagamento']);
        $dados_salvar['qtd_logins'] = $dados_plano['qtd_login'];
        $dados_salvar['valor_pagamento'] = $dados_plano['valor_cobrado'];
        $dados_salvar['detalhes'] = "<p><strong>ID Plano: </strong> {$dados_plano['id']}</p>"
                . "<p><strong>Desc Plano:</strong> {$dados_plano['desc_plano']}</p>";
        $dados_salvar['data_cad'] = $dados_salvar['data_atualizacao'] = date('Y-m-d');
        $dados_salvar['status'] = 1;

        $dados_extras['nome'] = $this->_antiSqlInject($_POST['nome']);
        $dados_extras['is_cnpj'] = isset($_POST['is_cpnj']) ? true : false;
        $dados_extras['cpf_cnpj'] = preg_replace('/[^0-9]/', '', $this->_antiSqlInject($_POST['cpf_cnpj']));

        $dados_salvar['detalhes'] .= "<hr/><p><strong>Nome/Fantasia:</strong> {$dados_extras['nome']}</p>"
                . "<p><strong>CPF/CNPJ:</strong> {$_POST['cpf_cnpj']}</p>";

        if ($dados_extras['nome'] === "" || $dados_extras['cpf_cnpj'] === "") {

            if ($dados_extras['is_cnpj'] === true) {

                $javascript = <<< EOF
                 <script>
                    alert('Nome/Fantasia e CPNJ são obrigatórios.');
                    window.history.go(-1);
                 </script>                
EOF;
                exit($javascript);
            } else {

                $javascript = <<< EOF
                 <script>
                    alert('Nome e CPF são obrigatórios.');
                    window.history.go(-1);
                 </script>                
EOF;
                exit($javascript);
            }
        }

        //carregando validação de cpf e cnpj
        $this->load->library('valida_cpf_cnpj', array('valor' => $dados_extras['cpf_cnpj']));

        //validando documentos

        if (!$this->valida_cpf_cnpj->valida()) {

            $javascript = <<< EOF
                 <script>
                    alert('O CPF/CNPJ Informado é inválido');
                    window.history.go(-1);
                 </script>                
EOF;
            exit($javascript);
        }

        //cria uma nova transacao revenda
        if ($this->db->insert('cmum_transacoes_planos', $dados_salvar)) {

            if ($dados_salvar['tipo'] == 2) {

                $dados_revenda = dados_revenda($id_revenda,'email');
                $dados_revenda_pai = dados_revenda($id_pai, 'email_bf,token_bf');

                $dados_pagamento['token'] = $dados_revenda_pai['token_bf'];
                $dados_pagamento['desc_produto'] = $dados_plano['desc_plano'];
                $dados_pagamento['id_referencia'] = json_encode(array('tipo' => 'R', 'id' => $this->db->insert_id()));
                $dados_pagamento['valor_total'] = $dados_plano['valor_cobrado'];
                $dados_pagamento['nome_cliente'] = $dados_extras['nome'];
                $dados_pagamento['cpf_cpnj_cliente'] = $dados_extras['cpf_cnpj'];
                $dados_pagamento['email_cliente'] = $dados_revenda['email'];                

                $url_bf = cria_pagamento_bf($dados_pagamento);

                $retorno = retorno_bf($url_bf);
                
                exit(var_dump($url_bf,$dados_pagamento['token'],$retorno,__LINE__));
                
                if ($retorno->sucesso == true) {

                    // link do boleto
                    $url = $retorno->dados['data']['charges'][0]['link'];

                    $js = <<<js
                        <script>
                            alert('Dados da transação salvos com sucesso. Clique em Ok para baixar o seu boleto.');
                            window.open('$url');
                            window.close();
                        </script>   
js;
                    exit($js);
                }
            }

            exit('Entre em contato com o revendedor pois o mesmo não tem pagamento configurado corretamente.');
            // cria pagamento com boleto facil
        }
    }

    function planos_revendas($id = null) {
        header('Content-Type: application/json');

        $rs = $this->db->query('SELECT * FROM cmum_planos_pre ORDER BY ID DESC');

        $planos = array();

        if ($rs->num_rows() > 0) {
            $planos = $rs->result_array();
        }

        exit(json_encode($planos));
    }

    function carrega_historico_planos() {

        $revenda_id = $this->_antiSqlInject($this->sessao_nativa->get('adminid'));

        $rs = $this->db->query("SELECT * FROM cmum_transacoes_planos WHERE id_revenda={$revenda_id} ORDER BY id DESC");

        $hist_planos = array();

        $this->load->library('adapter_hist_plano');

        $adapter_hist_plano = $this->adapter_hist_plano;

        if ($rs->num_rows() > 0) {
            $hist_planos = $rs->result_array();
        }

        $this->load->view('Planos/planos.historico.php', array('hist_planos' => $hist_planos, 'adapter_hist_plano' => $adapter_hist_plano));
    }

    function planos_revendas_tab() {


        $revenda_id = $this->_antiSqlInject($this->sessao_nativa->get('adminid'));


        $rs = $this->db->query("SELECT * FROM cmum_planos_pre WHERE id_revenda={$revenda_id} ORDER BY ID DESC");

        $tabela = '<table class="table table-bordered">
                <thead>
                <th>#ID</th>
                <th>Plano</th>
                <th>Qtd Login:</th>
                <th>Valor Cobrado:</th>
                <th>Data Cadastro:</th>
                <th>Status:</th>
                <th>&nbsp;</th>
                </thead>
                <tbody>';

        if ($rs->num_rows() > 0) {

            $planos = $rs->result_array();

            foreach ($planos as $plano) {

                $data_cad = date('d/m/Y', strtotime($plano['data_cad']));
                $status = ($plano['status'] == 1) ? '<span class="label label-success">Ativo</span>' : '<span class="label label-danger">Desativado</span>';

                $tabela .= '<tr>'
                        . '<td>' . $plano['id'] . '</td>'
                        . '<td>' . $plano['desc_plano'] . '</td>'
                        . '<td>' . $plano['qtd_login'] . '</td>'
                        . '<td>' . $plano['valor_cobrado'] . '</td>'
                        . '<td>' . $data_cad . '</td>'
                        . '<td>' . $status . '</td>'
                        . '<td><a href="#" class="edt" edt-id="' . $plano['id'] . '">Editar</a>&nbsp;<a href="#" class="del" del-id="' . $plano['id'] . '">Remover</a></td>';
            }
        }
        $tabela .= '</tbody>'
                . '</table>';
        exit($tabela);
    }

    function carrega_um($id = null) {
        if (null === $id || !is_numeric($id)) {
            exit();
        }
        /*
          buscar se for pai
         */
        $rs = $this->db->query("SELECT * FROM cmum_planos_pre WHERE id={$id}");

        if ($rs->num_rows() > 0) {
            $plano = $rs->row_array();
        }

        exit(json_encode($plano));
    }

    function delete_um($id_plano = null) {

        if (null === $id_plano || !is_numeric($id_plano)) {
            exit();
        }

        $retorno = array();

        if ($this->db->delete('cmum_planos_pre', array('id' => $id_plano))) {
            $retorno['sucesso'] = 'Dados Removidos Com Sucesso!';
        } else {
            $retorno['erro'] = 'Erro ao deletar os dados';
        }

        exit(json_encode($retorno));
    }

    function cancela_um($id_transacao_plano = null) {
        if (null === $id_transacao_plano || !is_numeric($id_transacao_plano)) {
            exit();
        }

        if ($this->db->update('cmum_transacoes_planos', array('status' => '0'), array('id' => $id_transacao_plano))) {
            $retorno = <<<EOF
                    <script>
                        alert('Transação cancelada com sucesso!');
                        window.close();
                    </script>
EOF;
        } else {
            $retorno = <<<EOF
                    <script>
                        alert('ERRO: A ação não pode ser concluida.');
                        window.close();
                    </script> 
EOF;
        }
        exit($retorno);
    }

    function testes() {
        header('Content-Type: application/json');

        $planos = array();

        exit(json_encode($planos));
    }

    function teste_cpf() {

        $this->load->library('valida_cpf_cnpj', array('valor' => '02054944393'));

        var_dump($this->valida_cpf_cnpj->valida());
        exit();

        /* require_once INC_GLOBAL . DIRECTORY_SEPARATOR . 'functions.php';

          var_dump(isCnpjValid('02930076000141')); */
    }

}
